IF EXISTS (select * from sysobjects where name like '%T_Insert_TipoConfiguracionEstacion%')
DROP TRIGGER T_Insert_TipoConfiguracionEstacion
go

CREATE TRIGGER [dbo].[T_Insert_TipoConfiguracionEstacion]
ON  [dbo].[TipoConfiguracionEstacion]
FOR INSERT, UPDATE
AS
	DECLARE @IdTipoConfiguracionEstacion DECIMAL(20,0);
	DECLARE @IdIdioma DECIMAL(20,0);
	DECLARE @Descripcio AS VARCHAR(100);
	DECLARE @Contador DECIMAL(10,0);
		
	DECLARE Elems_Cursor33333 CURSOR FOR
	SELECT IdTipoConfiguracionEstacion,Descripcio FROM INSERTED;
	OPEN Elems_Cursor33333

	FETCH NEXT FROM Elems_Cursor33333 INTO @IdTipoConfiguracionEstacion,@Descripcio
	WHILE @@FETCH_STATUS = 0
	BEGIN	

		PRINT 'Ejecucion trigger T_Insert_TipoConfiguracionEstacion.'
		/*Cogemos todos los idiomas y creamos los registros de etiquetas de idioma para el tipo de configuracin de estacin*/
		DECLARE Elems_Cursor44444 CURSOR FOR
		SELECT IdIdioma FROM Idioma;
		OPEN Elems_Cursor44444
		
		FETCH NEXT FROM Elems_Cursor44444 INTO @IdIdioma
		WHILE @@FETCH_STATUS = 0
		BEGIN
		
		/*Miramos que no exista ya el registro*/
		SELECT @Contador = Count(*)
						from EtiquetaIdioma
						where 1=1
						and EtiquetaIdioma.Concepto = 'TIPOCONFIGESTACION'
						and EtiquetaIdioma.Etiqueta = 'TIPOCONFIGESTACION_'+CONVERT(VARCHAR(20),@IdTipoConfiguracionEstacion)
						and EtiquetaIdioma.IdIdioma = @IdIdioma
		
		IF @Contador = 0 
		BEGIN 
			/*Para cada idioma que no es por defecto, creamos la instancia de EtiquetaIdioma*/
			INSERT INTO EtiquetaIdioma (Etiqueta,IdIdioma,Valor,Concepto) VALUES ('TIPOCONFIGESTACION_'+CONVERT(VARCHAR(20),@IdTipoConfiguracionEstacion),@IdIdioma,@Descripcio,'TIPOCONFIGESTACION')
		END
				
		FETCH NEXT FROM Elems_Cursor44444 INTO @IdIdioma
		END
		
		CLOSE Elems_Cursor44444
		DEALLOCATE Elems_Cursor44444
		
		/*Para el nuevo tipo de configuracin de estacin actualizamos el valor del campo TagIdioma*/
		UPDATE TipoEstacion SET TagIdioma='TIPOCONFIGESTACION_'+CONVERT(VARCHAR(20),@IdTipoConfiguracionEstacion) WHERE IdTipoEstacion=@IdTipoConfiguracionEstacion
		
	FETCH NEXT FROM Elems_Cursor33333 INTO @IdTipoConfiguracionEstacion,@Descripcio
	END

	CLOSE Elems_Cursor33333
	DEALLOCATE Elems_Cursor33333